topic "JobQueue";
[2 $$0,0#00000000000000000000000000000000:Default]
[i448;a25;kKO9;2 $$1,0#37138531426314131252341829483380:class]
[l288;2 $$2,2#27521748481378242620020725143825:desc]
[0 $$3,0#96390100711032703541132217272105:end]
[H6;0 $$4,0#05600065144404261032431302351956:begin]
[i448;a25;kKO9;2 $$5,0#37138531426314131252341829483370:item]
[l288;a4;*@5;1 $$6,6#70004532496200323422659154056402:requirement]
[l288;i1121;b17;O9;~~~.1408;2 $$7,0#10431211400427159095818037425705:param]
[i448;b42;O9;2 $$8,8#61672508125594000341940100500538:tparam]
[b42;2 $$9,9#13035079074754324216151401829390:normal]
[{_} 
[ {{10000@(113.42.0) [s0;%% [*@7;4 JobQueue]]}}&]
[s1;@(0.0.255)3 &]
[s1;:Upp`:`:JobQueue`:`:class: [@(0.0.255)3 class][3 _][*3 JobQueue][3 _:_][@(0.0.255)3 private][3 _
][*@3;3 Moveable][3 <][*3 JobQueue][3 >_]&]
[s2;#%% This helper base class implements a simple programmable job/queue 
model, and provides a uniform interface suitable mainly for, 
but not limited to, non`-blocking (asynchronous) [^topic`:`/`/Core`/src`/TcpSocket`$en`-us^ s
ocket] operations.&]
[s6;%% &]
[s6;%% This class requires at least C`+`+11&]
[s3; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Public Method List]]}}&]
[s3; &]
[s5;:Upp`:`:JobQueue`:`:Do`(`): [@(0.0.255) virtual] [@(0.0.255) bool]_[* Do]()&]
[s2;%% Progresses the job queue by executing the pending jobs. Returns 
true if processing is not finished. This method can be overridden. 
&]
[s3; &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:Execute`(`): [@(0.0.255) virtual] [@(0.0.255) bool]_[* Execute]()&]
[s2;%% Executes pending jobs in a blocking manner. Returns true if 
successful. This method can be overridden.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:InProgress`(`)const: [@(0.0.255) bool]_[* InProgress]()_[@(0.0.255) c
onst]&]
[s2;%% Returns true if an operation (a job or a set of jobs) is in 
progress.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:IsSuccess`(`)const: [@(0.0.255) bool]_[* IsSuccess]()_[@(0.0.255) c
onst]&]
[s2;%% Returns true if an operation (a job or a set of jobs) is successfully 
completed.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:IsFailure`(`)const: [@(0.0.255) bool]_[* IsFailure]()_[@(0.0.255) c
onst]&]
[s2;%% Returns true if an operation (a job or a set of jobs) has 
failed.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:GlobalTimeout`(int`): [@(0.0.255) void]_[* GlobalTimeout]([@(0.0.255) i
nt]_[*@3 ms])&]
[s2;%%  Sets the `"overall`" timeout interval for the [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] method in miliseconds. Zero is the default timeout value, 
and means that loop will be infinite (similar to while(1), or 
for(;;) loops).&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:WhenDo: [_^Upp`:`:Event^ Event]<>_[* WhenDo]&]
[s2;%% Invoked each time [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] method exits. Useful for updating GUI, etc.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:WhenHalt: [_^Upp`:`:Event^ Event]<>_[* WhenHalt]&]
[s2;%% Invoked when a queue is halted. It is invoked only once. Allows 
user to define a clean up method for failed operations.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:GetError`(`)const: [@(0.0.255) int]_[* GetError]()_[@(0.0.255) cons
t]&]
[s2;%% Returns error code. Generic error code is `-1.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:GetErrorDesc`(`)const: [@(0.0.255) const]_[_^Upp`:`:String^ Strin
g][@(0.0.255) `&]_[* GetErrorDesc]()_[@(0.0.255) const]&]
[s2; Returns last error message, if any.&]
[s3; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Protected Method List]]}}&]
[s0;^Upp`:`:Job^ &]
[s5;:Upp`:`:JobQueue`:`:AddJob`(`): [_^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:Job`:`:typedef^ J
ob][@(0.0.255) `&]_[* AddJob]()&]
[s2;%% Adds a vacant job to the queue. Returns a reference to the 
vacant job.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:AddJob`(const Upp`:`:Job`&`): [_^Upp`:`:JobQueue^ JobQueue][@(0.0.255) `&
]_[* AddJob]([@(0.0.255) const]_[_^Upp`:`:Job^ Job][@(0.0.255) `&]_[*@3 jb])&]
[s2;%%  Adds [%-*@3 jb] to the queue. Returns `*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:InsertJob`(int`): [_^Upp`:`:Job^ Job][@(0.0.255) `&]_[* InsertJob](
[@(0.0.255) int]_[*@3 i])&]
[s2;%% Inserts a vacant job the the queue at postion [%-*@3 i]. Returns 
a reference to the vacant job.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:InsertJob`(int`,const Upp`:`:Job`&`): [_^Upp`:`:JobQueue^ JobQu
eue][@(0.0.255) `&]_[* InsertJob]([@(0.0.255) int]_[*@3 i],[@(0.0.255) const]_[_^Upp`:`:Job^ J
ob][@(0.0.255) `&]_[*@3 jb])&]
[s2;%% Inserts [%-*@3 jb ][%- to the queue at position] [%-*@3 i]. Returns 
`*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:GetJob`(int`): [_^Upp`:`:Job^ Job][@(0.0.255) `&]_[* GetJob]([@(0.0.255) i
nt]_[*@3 i]_`=_[@3 0])&]
[s2;%% Returns a reference to the job at position [%-*@3 i].&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:RemoveJob`(int`): [@(0.0.255) void]_[* RemoveJob]([@(0.0.255) int]_
[*@3 i])&]
[s2;%% Removes the job at position [%-*@3 i] from the queue.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:NextJob`(`): [@(0.0.255) void]_[* NextJob]()&]
[s2;%% Removes the current/completed job from the queue, and starts 
the next job if any.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:ClearQueue`(`): [@(0.0.255) void]_[* ClearQueue]()&]
[s2;%% Clears the job queue and the error flag.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:QueueHasJobs`(`)const: [@(0.0.255) bool]_[* QueueHasJobs]()_[@(0.0.255) c
onst]&]
[s2;%% Returns true if there are pending jobs in the queue, excluding 
current job in progress.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:QueueIsHalted`(`)const: [@(0.0.255) bool]_[* QueueIsHalted]()_[@(0.0.255) c
onst]&]
[s2;%% Checks whether the queue is halted due to a fatal error.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:QueueIsEmpty`(`)const: [@(0.0.255) bool]_[* QueueIsEmpty]()_[@(0.0.255) c
onst]&]
[s2;%% Returns true if the job queue is empty.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:GetJobCount`(`)const: [@(0.0.255) int]_[* GetJobCount]()_[@(0.0.255) c
onst]&]
[s2;%% Returns the number of pending jobs in the job queue, including 
the the job in progress.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:Halt`(int`,const char`*`): [@(0.0.255) void]_[* Halt]([@(0.0.255) i
nt]_[*@3 rc], [@(0.0.255) const]_[@(0.0.255) char`*]_[*@3 reason]_`=_NULL)&]
[s2;%% Halts and clears the job queue, throwing an exception. This 
method should be invoked when a fatal error is occured.&]
[s3;%% &]
[s4;%% &]
[s5;:Upp`:`:JobQueue`:`:Halt`(const char`*`): [@(0.0.255) void]_[* Halt]([@(0.0.255) const]_
[@(0.0.255) char`*]_[*@3 reason]_`=_NULL)&]
[s2;%% Same as above method. Only difference is that this method 
sets the error code to `-1.&]
[s3;%% &]
[s4;%% &]
[s5;:Upp`:`:JobQueue`:`:IsTimeout`(`)const: [@(0.0.255) bool]_[* IsTimeout]()_[@(0.0.255) c
onst]&]
[s2;%% Returns true if operation is timed out.&]
[s4; &]
[s5;:Upp`:`:JobQueue`:`:IsCleanup`(`)const: [@(0.0.255) bool]_[* IsCleanup]()_[@(0.0.255) c
onst]&]
[s2;%% Returns true if the queue is halted and is in clean`-up stage.&]
[s3; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Constructor detail]]}}&]
[s2; &]
[s5;:Upp`:`:JobQueue`:`:JobQueue`(`): [* JobQueue]()&]
[s2;%% Default constructor&]
[s3; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Type definitions]]}}&]
[s3; &]
[s5;:Upp`:`:Job`:`:typedef: [@(0.0.255) typedef]_[_^Upp`:`:Function^ Function]<[@(0.0.255) b
ool]([@(0.0.255) void])>_[* Job]&]
[s2;%% Job is of [^topic`:`/`/Core`/src`/Callbacks`$en`-us^ Function] 
type with no arguments, and a boolean return value.&]
[s3;%% ]]